% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mosaic.tna_data}
\alias{plot_mosaic.tna_data}
\title{Plot state frequencies as a mosaic between two groups}
\usage{
\method{plot_mosaic}{tna_data}(x, group, label = "Group", digits = 1, ...)
}
\arguments{
\item{x}{A \code{tna_data} object.}

\item{group}{A \code{character} string giving the column name of the (meta) data
to contrast the frequencies with or a vector of group indicators with the
the same length as the number of rows in the sequence data.}

\item{label}{An optional \code{character} string that specifies a label for the
grouping variable when \code{group} is not a column name of the data.}

\item{digits}{An \code{integer} that determines the number of digits to use
for the chi-square test statistic and the p-value in the plot.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot state frequencies as a mosaic between two groups
}
\examples{
d <- data.frame(
  time = rep(1:5, rep = 4),
  group = rep(1:4, each = 5),
  event = sample(LETTERS[1:3], 20, replace = TRUE)
)
sequence_data <- prepare_data(
  d,
  time = "time",
  actor = "group",
  action = "event"
)
plot_mosaic(sequence_data, group = "group")

}
\seealso{
Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
