% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmt_sim.R
\name{tmt_sim}
\alias{tmt_sim}
\title{Function for the Simulation of Multistage-Designs}
\usage{
tmt_sim(mstdesign = NULL, items = NULL, persons = NULL, mean = 0,
  sd = 1, ...)
}
\arguments{
\item{mstdesign}{definition of desired multistage design}

\item{items}{vector of difficulty parameters for each items}

\item{persons}{amount of persons per starting module}

\item{mean}{optional mean for person parameter; default = 0}

\item{sd}{optional sd for person parameter; default = 1}

\item{...}{further optional arguments like \code{set.seed}}
}
\value{
List with following entries

 \item{data}{Matrix with item responses}
 \item{data_mst}{Data frame with item responses and additional a vector of used modules per person}
 \item{persons}{Generated and used person parameters}
 \item{mstdesign}{Submitted multistage design}
}
\description{
This function simulates data after a multistage design. The subjects are drawn from a normal 
distribution with specified mean and standard deviation (default N (0,1)). As an additional argument, 
a seed can also be passed.
}
\examples{
#############################################################################
# translate multistage model 1
#############################################################################
 mstdesign <- "
	 M1 =~ c(i1, i2, i3, i4, i5)
	 M2 =~ c(i6, i7, i8, i9, i10)
	 M3 =~ c(i11, i12, i13, i14, i15)

	 # define starting module
	 Start == M2

	 # define branches
	 p1 := Start(0,2) + M1
	 p2 := Start(3,5) + M3
 "
items <- seq(-3,3,length.out = 15)
names(items) <- paste0("i",1:15)

persons = 500
set.seed(1111)
data_1 <- tmt_sim(mstdesign = mstdesign, 
    items = items, 
    persons = persons, 
    mean = 0, 
    sd = 1)

#############################################################################
# translate multistage model 2
#############################################################################
mstdesign <- "
    M1 =~ c(i1, i2, i3, i4, i5)
    M2 =~ c(i6, i7, i8, i9, i10)
    M3 =~ c(i11, i12, i13, i14, i15)
    M4 =~ c(i16, i17, i18, i19, i20)
    M5 =~ c(i21, i22, i23, i24, i25)
    M6 =~ c(i26, i27, i28, i29, i30)

    # define starting module
    Start == M4

    # define branches
    p1 := Start(0,2) + M2(0,2) + M1
    p2 := Start(0,2) + M2(3,5) + M3
    p3 := Start(3,5) + M5(0,2) + M3
    p4 := Start(3,5) + M5(3,5) + M6
  "

items <- seq(-3,3,length.out = 30)
names(items) <- paste0("i",1:30)
persons = 500
set.seed(1111)
data_2 <- tmt_sim(mstdesign = mstdesign, 
    items = items, 
    persons = persons, 
    mean = 0, 
    sd = 1)
}
\author{
Jan Steinfeld
}
