% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{hgEnrichmentPlot}
\alias{hgEnrichmentPlot}
\title{Create a visualisation of enrichment}
\usage{
hgEnrichmentPlot(fg, bg, m, mset = "all", ...)
}
\arguments{
\item{fg}{the foreground set of genes}

\item{bg}{the background set of genes (gene universe)}

\item{m}{gene set for which the plot should be created}

\item{mset}{Which module set to use (see tmodUtest for details)}

\item{...}{additional parameters to be passed to the plotting function}
}
\description{
Create a visualisation of enrichment
}
\details{
This functions creates a barplot visualizing the enrichment of a
module in the foreground (fg) set as compared to the background (bg) set.
It is the counterpart
}
\examples{
set.seed(123)
data(tmod)
bg <- tmod$gv
fg <- getGenes("LI.M127", as.list=TRUE)[[1]]
fg <- sample(c(fg, bg[1:100]))
hgEnrichmentPlot(fg, bg, "LI.M127")
}
\seealso{
\code{\link{tmod-package}}, [evidencePlot()]
}
