% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/panelplots.R
\name{tmodSummary}
\alias{tmodSummary}
\title{Create a summary of multiple tmod analyses}
\usage{
tmodSummary(x, clust = NULL, filter.empty = FALSE, filter.unknown = TRUE)
}
\arguments{
\item{x}{list, in which each element has been generated with a tmod test function}

\item{clust}{whether, in the resulting data frame, the modules should be
ordered by clustering them with either q-values ("qval") or the effect size
("effect"). If NULL, the modules are sorted alphabetically by their ID.}

\item{filter.empty}{If TRUE, all elements (columns) with no significant enrichment will be removed}

\item{filter.unknown}{If TRUE, modules with no annotation will be omitted}
}
\value{
a data frame with a line for each module encountered anywhere in
the list x, two columns describing the module (ID and module title), and
two columns(effect size and q value) for each element of list x.
}
\description{
Create a summary of multiple tmod analyses
}
\details{
This function is useful if you run an analysis for several conditions or
time points and would like to summarize the information in a single data
frame. You can use lapply() to generate a list with tmod results and use
tmodSummary to convert it to a data frame.
}
\examples{
data(Egambia)
E <- Egambia[,-c(1:3)]
pca <- prcomp(t(E), scale.=TRUE)

# Calculate enrichment for each component
gs   <- Egambia$GENE_SYMBOL
gn.f <- function(r) {
    tmodCERNOtest(gs[order(abs(r),
                decreasing=TRUE)],
                qval=0.01)
}
x <- apply(pca$rotation, 2, gn.f)
tmodSummary(x)
}
\seealso{
tmodPanelPlot
}

