% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_projection.R
\name{set_projection}
\alias{set_projection}
\alias{get_projection}
\title{Set and get the map projection}
\usage{
set_projection(shp, projection = NA, current.projection = NA,
  overwrite.current.projection = FALSE)

get_projection(shp, as.CRS = FALSE, guess.longlat = FALSE)
}
\arguments{
\item{shp}{shape object of class \code{\link[sp:Spatial]{Spatial}},
\code{\link[raster:Raster-class]{Raster}}, or \code{sf} (see details).}

\item{projection}{new projection. See \code{\link{get_proj4}} for options. This argument is only used to transform the \code{shp}. Use \code{current.projection} to specify the current projection of \code{shp}.}

\item{current.projection}{the current projection of \code{shp}. See \code{\link{get_proj4}} for possible options. Only use this if the current projection is missing or wrong.}

\item{overwrite.current.projection}{logical that determines whether the current projection is overwritten if it already has a projection that is different.}

\item{as.CRS}{should a CRS object be returned instead of a PROJ.4 character string? Default is \code{FALSE}.}

\item{guess.longlat}{if \code{TRUE}, it checks if the coordinates are within -180/180 and -90/90, and if so, it returns the WGS84 longlat projection (which is \code{get_proj4("longlat")}).}
}
\value{
\code{set_projection} returns a (transformed) shape object with updated projection information. \code{get_projection} returns the \code{PROJ.4} character string of \code{shp}.
}
\description{
The function \code{set_projection} sets the projection of a shape file. It is
a convenient wrapper of \code{\link[sp:spTransform]{spTransform}} and
\code{\link[raster:projectRaster]{projectRaster}} with shortcuts for commonly
used projections. The projection can also be set directly in the plot call
with \code{\link[tmap:tm_shape]{tm_shape}}. This function is also used to set the current
projection information if this is missing. The function \code{get_projection}
is used to get the projection information.
}
\details{
For raster objects, the projection method is based on the type of data. For numeric layers, the bilinear method is used, and for categorical layers the nearest neighbor. See \code{\link[raster:projectRaster]{projectRaster}} for details.
}
