% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_components.R
\name{tm_credits}
\alias{tm_credits}
\title{Map component: (credits) text}
\usage{
tm_credits(
  text,
  size,
  color,
  padding,
  fontface,
  fontfamily,
  alpha,
  stack,
  just,
  frame,
  frame.lwd,
  frame.r,
  bg.color,
  bg.alpha,
  position,
  width,
  height,
  group.frame,
  resize_as_group,
  z,
  ...
)
}
\arguments{
\item{text}{text}

\item{size}{font size}

\item{color}{font color}

\item{padding}{padding}

\item{fontface}{font face, bold, italic}

\item{fontfamily}{font family}

\item{alpha}{alpha transparency of the text}

\item{stack}{stack with other map components, either \code{"vertical"} or \code{"horizontal"}.}

\item{just}{just}

\item{frame}{frame}

\item{frame.lwd}{frame line width}

\item{frame.r}{Radius of the rounded frame corners. 0 means no rounding.}

\item{bg.color}{Background color}

\item{bg.alpha}{Background transparency}

\item{position}{An object created with \code{tm_pos_in()} or \code{tm_pos_out()}. Or, as a shortcut, a vector of two values, specifying the x and y coordinates. The first is \code{"left"}, \code{"center"} or \code{"right"} (or upper case, meaning tighter to the map frame), the second \code{"top"}, \code{"center"} or \code{"bottom"}. Numeric values are also supported, where 0, 0 means left bottom and 1, 1 right top. See also \href{https://r-tmap.github.io/tmap/articles/adv_positions}{vignette about positioning}.}

\item{width, height}{width and height of the text box.}

\item{group.frame}{group.frame}

\item{resize_as_group}{resize_as_group}

\item{z}{z}

\item{...}{to catch deprecated arguments}
}
\description{
Map component that adds a text, typically used as credits. This function is the same as \code{\link[=tm_title]{tm_title()}} but with different default values.
}
\seealso{
\href{https://r-tmap.github.io/tmap/articles/basics_components}{Vignette about components}
}
