% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{plot.benchmark_fitsae}
\alias{plot.benchmark_fitsae}
\title{Plot Method for \code{benchmark_fitsae} Object}
\usage{
\method{plot}{benchmark_fitsae}(x, ...)
}
\arguments{
\item{x}{A \code{benchmark_fitsae} object.}

\item{...}{Currently unused.}
}
\value{
A \code{ggplot2} object.
}
\description{
The method \code{plot()} provides the boxplots of original and benchmarked estimates in comparison with the benchmark value. Note that share weights are not considered.
}
\examples{
library(tipsae)

# loading toy dataset
data("emilia_cs")

# fitting a model
fit_beta <- fit_sae(formula_fixed = hcr ~ x, data = emilia_cs, domains = "id",
                    type_disp = "var", disp_direct = "vars", domain_size = "n",
                    # MCMC setting to obtain a fast example. Remove next line for reliable results.
                    chains = 1, iter = 150, seed = 0)

# check model diagnostics
summ_beta <- summary(fit_beta)

# creating a subset of the areas whose estimates have to be benchmarked
subset <- c("RIMINI", "RICCIONE", "RUBICONE", "CESENA - VALLE DEL SAVIO")

# creating population shares of the subset areas
pop <- emilia_cs$pop[emilia_cs$id \%in\% subset]
shares_subset <- pop / sum(pop)

# perform benchmarking procedure
bmk_subset <- benchmark(x = summ_beta,
                        bench = 0.13,
                        share = shares_subset,
                        method = "raking",
                        areas = subset)
plot(bmk_subset)


}
\seealso{
\code{\link{benchmark}} to produce the input object.
}
