% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coefficient.R
\name{adjust_coef}
\alias{adjust_coef}
\title{Adjust an observed regression coefficient for a normally distributed
confounder}
\usage{
adjust_coef(effect, smd, outcome_association, verbose = TRUE)
}
\arguments{
\item{effect}{Numeric. Observed exposure - outcome effect from a regression
model. This can be the beta coefficient, the lower confidence bound of
the beta coefficient, or the upper confidence bound of the beta
coefficient.}

\item{smd}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{outcome_association}{Numeric. Estimated association
between the unmeasured confounder and the outcome.}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}
}
\value{
Data frame.
}
\description{
Adjust an observed regression coefficient for a normally distributed
confounder
}
\examples{
## Update an observed coefficient of 0.5 with an unmeasured confounder
## with a difference in scaled means between exposure groups of 0.2
## and coefficient of 0.3
adjust_coef(0.5, 0.2, 0.3)
}
