% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_inops.control.R
\name{import_inops.control}
\alias{import_inops.control}
\title{import_inops.control}
\usage{
import_inops.control(
  exclude = NULL,
  include.only = NULL,
  overwrite = TRUE,
  inherits = FALSE
)
}
\arguments{
\item{exclude}{a character vector,
giving the infix operators NOT to expose to the current environment. \cr
This can be handy to prevent overwriting any (user defined)
infix operators already present in the current environment. \cr}

\item{include.only}{a character vector,
giving the infix operators to expose to the current environment,
and the rest of the operators will not be exposed. \cr
This can be handy to prevent overwriting any (user defined)
infix operators already present in the current environment. \cr}

\item{overwrite}{logical,
indicating if it is allowed to overwrite existing infix operators.
\itemize{
\item If \code{TRUE} (default), a warning is given when operators existing in the current environment
are being overwritten,
but the function continuous nonetheless.
\item If \code{FALSE}, an error is produced
when the to be exposed operators already exist in the current environment,
and the function is halted.
}}

\item{inherits}{logical; indicating whether
enclosed environments,
especially package namespaces,
should also be taken into account (\code{TRUE}), or not (\code{FALSE}). \cr
Defaults to \code{FALSE}. \cr
See also \link[base]{exists}. \cr}
}
\value{
This function is used internally in the \link{import_inops} function.
}
\description{
Additional arguments to control exposing infix operators in the \link{import_inops} function.
}
\details{
You cannot specify both the \code{exclude} and \code{include.only} arguments.
Only one or the other, or neither. \cr
\cr
}
\examples{

# additional arguments (only used when exposing, not unexposing):
import_as(~ stri., "stringi")
import_inops(expose = stri., include.only = "\%s==\%")
import_inops(unexpose = stri.)
import_inops(expose = "stringi", exclude = "\%s==\%")
import_inops(unexpose = "stringi")
import_inops(expose = stri., overwrite = FALSE)
import_inops(unexpose = stri.)
import_inops(expose = "stringi", overwrite = FALSE)
import_inops(unexpose = "stringi")


}
\seealso{
\code{\link[=import_inops]{import_inops()}}, \code{\link[=tinycodet_import]{tinycodet_import()}}
}
