#' The 'tinycodet' Introduction Help Page
#'
#'
#' @description
#'
#' Welcome to the 'tinycodet' introduction help page! \cr
#' \cr
#' 'tinycodet' adds a few functions to help in your coding etiquette. \cr
#' It primarily focuses on 4 things: \cr
#' \cr
#' (1) Safer decimal (in)equality testing, safer atomic conversions, and other functions for safer coding; \cr
#' see \link{tinycodet_safer}. \cr
#' \cr
#' (2) A new package import system,
#' that attempts to combine the benefits of using a package without attaching,
#' with the benefits of attaching a package; \cr
#' see \link{tinycodet_import} \cr
#' \cr
#' (3) Extending the string manipulation capabilities of the 'stringi' R-package; \cr
#' see \link{tinycodet_strings}. \cr
#' \cr
#' (4) Reducing repetitive code; \cr
#' see \link{tinycodet_dry}. \cr
#' \cr
#' And some miscellaneous functionality; see \link{tinycodet_misc}. \cr
#' \cr
#'
#' 'tinycodet' adheres to the
#' \href{https://www.tinyverse.org/}{tinyverse}
#' philosophy
#' (not to be confused with the 'tidyverse').
#' 'tinycodet' has only one dependency,
#' namely 'stringi'. No other dependencies, thus avoiding "dependency hell".
#' Most functions in this R-package are vectorized and optimised. \cr
#' \cr
#'
#'
#' @author \strong{Maintainer}: Tony Wilkes \email{tony_a_wilkes@outlook.com} (\href{https://orcid.org/0000-0001-9498-8379}{ORCID})
#'
#' @seealso
#'
#' Useful links:
#'
#'  * 'tinycodet' GitHub page: \url{https://github.com/tony-aw/tinycodet/}
#'  * 'tinycodet' package website: \url{https://tony-aw.github.io/tinycodet/}
#'  * Report bugs at: \url{https://github.com/tony-aw/tinycodet/issues/}
#'  * The 'fastverse', which is related to the 'tinyverse': \url{https://github.com/fastverse/fastverse/}
#'
#' @references The badges shown in the documentation of this R-package were made using the services of: \url{https://shields.io/}
#'

#' @rdname tinycodet_help
#' @name tinycodet_help
#' @aliases tinycodet-package
#' @aliases tinycodet
#' @aliases tinycodet_help
NULL
