% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_survival_cut_cox_km.R
\name{surv_KM}
\alias{surv_KM}
\title{surv_KM}
\usage{
surv_KM(
  exprSet_hub,
  meta,
  cut.point = FALSE,
  pvalue_cutoff = 0.05,
  min_gn = 0.1
)
}
\arguments{
\item{exprSet_hub}{a tumor expression set for hubgenes}

\item{meta}{meta data corresponds to expression set}

\item{cut.point}{logical , use cut_point or not, if FALSE,use median by defult}

\item{pvalue_cutoff}{p value cut off ,0.05 by defult}

\item{min_gn}{Depending on the expression of a gene, there may be a large difference in the number of samples between the two groups, and if a smaller group of samples is less than 10 percent (default) of all, the gene will be discarded}
}
\value{
a vector with gene names and log_rank p value
}
\description{
calculate log_rank test p values for genes
}
\examples{
surv_KM(exprSet_hub1,meta1)
surv_KM(exprSet_hub1,meta1,pvalue_cutoff = 1)
surv_KM(exprSet_hub1,meta1,cut.point = TRUE)
}
\seealso{
\code{\link{point_cut}};\code{\link{surv_cox}}
}
\author{
Xiaojie Sun
}
