% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_tsne}
\alias{draw_tsne}
\title{draw_tsne}
\usage{
draw_tsne(
  exp,
  group_list,
  perplexity = 30,
  color = c("#2874C5", "#f87669", "#e6b707", "#868686", "#92C5DE", "#F4A582",
    "#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F", "#E5C494",
    "#B3B3B3"),
  color.label = "group",
  addEllipses = TRUE
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{perplexity}{numeric; perplexity parameter for Rtsne}

\item{color}{color vector}

\item{color.label}{color legend label}

\item{addEllipses}{logical,add ellipses or not}
}
\value{
a ggplot object
}
\description{
draw tsne plot with annotation by ggplot2
}
\examples{
exp <-  matrix(rnorm(10000),nrow = 50)
colnames(exp) <- paste0("sample",1:200)
rownames(exp) <- paste0("gene",1:50)
exp[1:4,1:4]
exp[,1:100] = exp[,1:100]+10
group_list <- factor(rep(c("A","B"),each = 100))
draw_tsne(exp,group_list)
}
\author{
Xiaojie Sun
}
