% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format}
\alias{format}
\alias{strptind}
\alias{format.tind}
\title{Conversion between Objects of \code{tind} Class and Character Vectors}
\usage{
\method{format}{tind}(x, format, locale = NULL, ...)

strptind(x, format, locale = NULL, type = NULL, tz = NULL)
}
\arguments{
\item{x}{an object to be converted, a character vector for \code{strptind},
an object of \code{tind} class for \code{format}.}

\item{format}{a character string or character vector determining string format(s) (see Details).}

\item{locale}{a character value determining locale to be used for \code{\%a},
\code{\%A}, \code{\%b}, \code{\%B}, and \code{\%p} specifiers
(month names, weekday names, and AM/PM indicators) or \code{NULL}
(default, interpreted as the current system locale),
see \link{calendar-names} for information on locale settings.}

\item{...}{(ignored) further arguments passed to or from other methods.}

\item{type}{(optional) a character value determining time index type.}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}
}
\value{
\code{strptime} returns an object of \code{tind} class, \code{format}
returns a character vector.
}
\description{
\code{format} method converts objects of \code{tind} class to character
vectors given format and locale information. \code{strptind} function
accepts character vector with time indices and parses to create object
of \code{tind} class.
}
\details{
Names of accepted format specifiers except for \code{\%q} are conformant
with those used by \code{\link[base]{format.Date}}, \code{\link[base]{format.Date}}
and \code{\link[base]{strptime}}. Accepted specifiers are listed below:
\describe{
    \item{\code{\%a}}{Abbreviated weekday name.}
    \item{\code{\%A}}{Weekday name.}
    \item{\code{\%b}}{Abbreviated month name.}
    \item{\code{\%B}}{Month name.}
    \item{\code{\%d}}{Day of month (01--31).}
    \item{\code{\%e}}{Day of month (1--31) with a leading space for a single-digit number.}
    \item{\code{\%D}}{American/C99 date representation \code{\%m/\%d/\%y}.}
    \item{\code{\%F}}{ISO 8601 date \code{\%Y-\%m-\%d}.}
    \item{\code{\%g}}{The last two digits of the week-based year.}
    \item{\code{\%G}}{The week-based year.}
    \item{\code{\%H}}{Hour (00--23).}
    \item{\code{\%I}}{Hour, 12-hour clock (1--12).}
    \item{\code{\%p}}{AM/PM indicator.}
    \item{\code{\%j}}{Day of year (001--366).}
    \item{\code{\%m}}{Month (01--12).}
    \item{\code{\%M}}{Minute (00--59).}
    \item{\code{\%n}}{Newline.}
    \item{\code{\%OS[n]}}{Second with \code{n} (0--6) decimal places.}
    \item{\code{\%OS}}{Second with up to 6 decimal places (automatically detected precision during parsing).}
    \item{\code{\%q}}{(Not supported by base R.) Quarter (1--4).}
    \item{\code{\%R}}{Same as \code{\%H:\%M}.}
    \item{\code{\%S}}{Second (00--59), leap seconds are not accepted on input.}
    \item{\code{\%t}}{Tab or whitespace.}
    \item{\code{\%T}}{Same as \code{\%H:\%M:\%S}.}
    \item{\code{\%u}}{Weekday (1--7) with Monday as the first day in a week (ISO 8601).}
    \item{\code{\%V}}{Week (01--53) as defined in ISO 8601.}
    \item{\code{\%y}}{2-digit year (00--99), values 00--68 are prefixed by 20 and 69--99 by 19.}
    \item{\code{\%Y}}{4-digit year (0--9999), 0 is allowed by ISO 8601.}
    \item{\code{\%z}}{Signed offset in hours and minutes from UTC, accepted
                      input formats are \code{+-HHMM}, \code{+-HH},
                      \code{+-HH:MM}, and letter \code{Z} for UTC.}
    \item{\code{\%Z}}{Time zone abbreviation (also supported on input).}
}

On very rare occasions (the need to use formats unsupported by \code{strptind})
users will have to call \code{\link[base]{strptime}} and then \code{as.tind}
method or perform some regex preprocessing before calling \code{strptind}.

\code{type} argument is optional as \code{strptind} automatically determines
index type from components. However, it can be set as a safeguard against format
misspecifications.
}
\note{
The following \code{\link[base]{strptime}} specifiers (as well as some others)
are not supported (most often because they are locale specific or do not
comply with ISO 8601):
\describe{
    \item{\code{\%c}}{Locale-specific date and time.}
    \item{\code{\%C}}{Century (00--99).}
    \item{\code{\%h}}{Equivalent to \code{\%b}.}
    \item{\code{\%r}}{12-hour clock time using AM/PM indicator.}
    \item{\code{\%U}}{Week of the year (US convention).}
    \item{\code{\%w}}{Weekday (0--6).}
    \item{\code{\%W}}{Week of the year (UK convention).}
    \item{\code{\%x}}{Locale-specific date.}
    \item{\code{\%X}}{Locale-specific time.}
}
}
\examples{
## years
# four-digit year
(ti <- strptind(as.character(1998:2002), "\%Y"))
format(ti, "\%Y")
# two-digit year
(ti <- strptind(c("98", "99", "00", "01", "02"), "\%y"))
format(ti, "\%y")
# mixture of four-digit and two-digit years
strptind(c("1998", "1999", "00", "01", "02"), c("\%Y", "\%y"))

## quarters
(ti <- strptind(c("2020Q1", "2020Q2", "2020Q3", "2020Q4"), "\%YQ\%q"))
format(ti, "\%YQ\%q")
format(ti, "\%Yq\%q")
format(ti, "\%Y.\%q")

## months
(ti <- strptind(c("2020-03", "2020-06", "2020-09", "2020-12"), "\%Y-\%m"))
format(ti, "\%Y-\%m")
(ti <- strptind(c("03/20", "06/20", "09/20", "12/20"), "\%m/\%y"))
format(ti, "\%m/\%y")
format(ti, "\%b '\%y")

## weeks
(ti <- strptind(c("2020-W01", "2020-W05", "2020-W09", "2020-W13"), "\%G-W\%V"))
format(ti, "\%G-W\%V")
format(ti, "\%G, week: \%V")
strptind(c("2020, week: 13"), "\%G, week: \%V")

## dates
# ISO format
(ti <- strptind(c("2025-03-19", "2025-06-18", "2025-09-17", "2025-12-17"), "\%F"))
format(ti, "\%F")
strptind(c("2025-03-19", "2025-06-18", "2025-09-17", "2025-12-17"), "\%Y-\%m-\%d")
format(ti, "\%Y-\%m-\%d")
# US format
strptind(c("03/19/25", "06/18/25", "09/17/25", "12/17/25"), "\%D")
format(ti, "\%D")
strptind(c("03/19/25", "06/18/25", "09/17/25", "12/17/25"), "\%m/\%d/\%y")
format(ti, "\%m/\%d/\%y")
# European format
strptind(c("19.03.2025", "18.06.2025", "17.09.2025", "17.12.2025"), "\%d.\%m.\%Y")
format(ti, "\%d.\%m.\%Y")
# mixed formats
strptind(c("03/19/25", "06/18/25", "17.09.2025", "17.12.2025"),
         c("\%m/\%d/\%y", "\%d.\%m.\%Y"))
strptind(c("03/19/25", "06/18/25", "2025-09-17", "2025-12-17"),
         c("\%D", "\%F"))

## time of day
(ti <- strptind("13:03:34.534", "\%H:\%M:\%OS"))
format(ti, "\%H:\%M:\%OS3")
format(ti, "\%H:\%M:\%OS2")
format(ti, "\%H:\%M:\%OS1")
strptind("13:03:34", "\%H:\%M:\%S")
format(ti, "\%H:\%M:\%S")
strptind("13:03", "\%H:\%M")
format(ti, "\%H:\%M")
strptind("13", "\%H")
format(ti, "\%H")
strptind("01:03:44 pm", "\%I:\%M:\%S \%p")
format(ti, "\%I:\%M:\%S \%p")
strptind("1:03:44 pm", "\%I:\%M:\%S \%p")
strptind(c("1am", "1pm"), "\%I\%p")

## date-time
(ti <- strptind("2025-02-01 13:03:34.534", "\%F \%H:\%M:\%OS"))
format(ti, "\%F \%H:\%M:\%S")
format(ti, "\%F \%H:\%M:\%OS2")
format(ti, "\%F \%H:\%M:\%S\%z")
format(ti, "\%F \%H:\%M:\%OS2 \%Z")
strptind("02/01/25 01:03:34pm", "\%D \%I:\%M:\%OS\%p")

}
\seealso{
\code{\link{parse_t}} for easier to use index parsing requiring
order specification only, \link{calendar-names} for information on locale settings.
}
