% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sffsBinary1.R
\name{sffsBinary1}
\alias{sffsBinary1}
\title{Model selection with sffs for the binary drug-target interaction data using two.sided TIMMA model}
\usage{
sffsBinary1(profile_data, sens, sp = 1, max_k = 2, loo = TRUE,
  verbosity = FALSE)
}
\arguments{
\item{profile_data}{drug-target interaction data which is a matrix with drugs as row indexes and targets
as column indexes.}

\item{sens}{a drug sensitivity vector.}

\item{sp}{an integer to specify the starting point for sequential forward floating search (sffs) search
algorithm to navigate the target set space. By default, sp = 1.}

\item{max_k}{an integer to sepcify the maximum number of targets that can be selected by the sffs
algorithm. By default, max_k = 2. In practice it should not be over than 10 as the number of target combinations will increase exponentially.}

\item{loo}{a logical value indicating whether to use the leave-one-out cross-validation in the model
selection process. By default, loo = TRUE.}

\item{verbosity}{a boolean value to decide if the information should be displayed. If it is TRUE, the information
will be displayed while the model is running. Otherwise, the information will not be displayed. By default, it is
FALSE.}
}
\value{
A list containing the following components:
\item{timma}{a list contains: the predicted efficacy matrix, prediction error and predicted drug sensitivity}
\item{k_sel}{the indexes for selected targets}
}
\description{
A function to select the most predictive targets with sffs for the binary drug-target interaction data using
two.sided TIMMA model
}
\details{
The major difference between original and modified averaging method is the averaging methods for the case where the minimization and maximization rules are not simultaneously satisfied.
For example, for a queried target set there are supersets but not subsets in the training data, the original algorithm will take the prediction from these supersets data using the minimization rule.
However, the modified algorithm will further adjust the prediction using the average between such a prediction and 0.
}
\examples{
\dontrun{
data(tyner_interaction_binary)
data(tyner_sensitivity)
results<-sffsBinary1(tyner_interaction_binary, tyner_sensitivity[, 1], max_k = 2)
}
}
\author{
Liye He \email{liye.he@helsinki.fi}
}
\references{
Tang J, Karhinen L, Xu T, Szwajda A, Yadav B, Wennerberg K, Aittokallio T.
Target inhibition networks: predicting selective combinations of druggable targets to block cancer
survival pathways. PLOS Computational Biology 2013; 9: e1003226.
}

