% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_holiday_signature.R
\name{step_holiday_signature}
\alias{step_holiday_signature}
\alias{tidy.step_holiday_signature}
\title{Holiday Feature (Signature) Generator}
\usage{
step_holiday_signature(
  recipe,
  ...,
  holiday_pattern = ".",
  locale_set = "all",
  exchange_set = "all",
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  features = NULL,
  skip = FALSE,
  id = rand_id("holiday_signature")
)

\method{tidy}{step_holiday_signature}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables that will be used to create the new variables. The
selected variables should have class \code{Date} or
\code{POSIXct}. See \code{\link[recipes:selections]{recipes::selections()}} for more details.
For the \code{tidy} method, these are not currently used.}

\item{holiday_pattern}{A regular expression pattern to search the "Holiday Set".}

\item{locale_set}{Return binary holidays based on locale.
One of: "all", "none", "World", "US", "CA", "GB", "FR", "IT", "JP", "CH", "DE".}

\item{exchange_set}{Return binary holidays based on Stock Exchange Calendars.
One of: "all", "none", "NYSE", "LONDON", "NERC", "TSX", "ZURICH".}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new variable columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{\link[recipes:prep.recipe]{recipes::prep.recipe()}} is used.}

\item{features}{A character string of features that will be
generated. This field is a placeholder and will be
populated once \code{\link[recipes:prep.recipe]{recipes::prep.recipe()}} is used.}

\item{skip}{A logical. Should the step be skipped when the recipe is
baked by bake.recipe()? While all operations are baked when prep.recipe()
is run, some operations may not be able to be conducted on new data
(e.g. processing the outcome variable(s)). Care should be taken when
using skip = TRUE as it may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_holiday_signature} object.}
}
\value{
For \code{step_holiday_signature}, an updated version of recipe with
the new step added to the sequence of existing steps (if any).
For the \code{tidy} method, a tibble with columns \code{terms}
(the selectors or variables selected), \code{value} (the feature
names).
}
\description{
\code{step_holiday_signature} creates a a \emph{specification} of a recipe
step that will convert date or date-time data into many
holiday features that can aid in machine learning with time-series data.
By default, many features are returned for different \emph{holidays, locales, and stock exchanges}.
}
\details{
\strong{Use Holiday Pattern and Feature Sets to Pare Down Features}
By default, you're going to get A LOT of Features. This is a good thing because many
machine learning algorithms have regularization built in. But, in many cases you
will still want to reduce the number of \emph{unnecessary features}. Here's how:
\itemize{
\item \strong{Holiday Pattern:} This is a Regular Expression pattern that can be used to filter.
Try \code{holiday_pattern = "(US_Christ)|(US_Thanks)"} to return just Christmas and Thanksgiving
features.
\item \strong{Locale Sets:} This is a logical as to whether or not the locale has a holiday.
For locales outside of US you may want to combine multiple locales.
For example, \code{locale_set = c("World", "GB")} returns both World Holidays and Great Britain.
\item \strong{Exchange Sets:} This is a logical as to whether or not the \emph{Business is off} due
to a holiday. Different Stock Exchanges are used as a proxy for business holiday calendars.
For example, \code{exchange_set = "NYSE"} returns business holidays for New York Stock Exchange.
}

\strong{Removing Unnecessary Features}
By default, many features are created automatically. Unnecessary features can
be removed using \code{\link[recipes:step_rm]{recipes::step_rm()}} and \code{\link[recipes:selections]{recipes::selections()}} for more details.
}
\examples{
library(recipes)
library(timetk)
library(tidyverse)

# Sample Data
dates_in_2017_tbl <- tibble(
    index = tk_make_timeseries("2017-01-01", "2017-12-31", by = "day")
)

# Add US holidays and Non-Working Days due to Holidays
# - Physical Holidays are added with holiday pattern (individual) and locale_set
rec_holiday <- recipe(~ ., dates_in_2017_tbl) \%>\%
    step_holiday_signature(index,
                           holiday_pattern = "^US_",
                           locale_set      = "US",
                           exchange_set    = "NYSE")

# Not yet prep'ed - just returns parameters selected
rec_holiday \%>\% tidy(1)

# Prep the recipe
rec_holiday_prep <- prep(rec_holiday)

# Now prep'ed - returns new features that will be created
rec_holiday_prep \%>\% tidy(1)

# Apply the recipe to add new holiday features!
bake(rec_holiday_prep, dates_in_2017_tbl)




}
\seealso{
Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{\link[recipes:step_lag]{recipes::step_lag()}}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_box_cox]{step_box_cox()}}
\item Imputation: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
\item Padding: \code{\link[=step_ts_pad]{step_ts_pad()}}
}

Main Recipe Functions:
\itemize{
\item \code{\link[recipes:recipe]{recipes::recipe()}}
\item \code{\link[recipes:prep.recipe]{recipes::prep.recipe()}}
\item \code{\link[recipes:bake.recipe]{recipes::bake.recipe()}}
}
}
\concept{dates}
\concept{model_specification}
\concept{preprocessing}
\concept{variable_encodings}
\keyword{datagen}
