% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/places.R
\name{places}
\alias{places}
\title{Download a Census-designated places shapefile into R}
\usage{
places(state = NULL, cb = FALSE, year = NULL, ...)
}
\arguments{
\item{state}{The two-digit FIPS code (string) of the state you want. Can also
be state name or state abbreviation. When \code{NULL} and combined with
\code{cb = TRUE}, a national dataset of places will be returned for years
2019 and later.}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).}

\item{year}{the data year; defaults to 2021}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Census Designated Places (CDPs) are the statistical counterparts of
incorporated places, and are delineated to provide data for settled
concentrations of population that are identifiable by name but are
not legally incorporated under the laws of the state in which they
are located.
}
\details{
The boundaries usually are defined in cooperation with local or tribal
officials and generally updated prior to each decennial census.

These boundaries, which usually coincide with visible features or the
boundary of an adjacent incorporated place or another legal entity boundary,
have no legal status, nor do these places have officials elected to serve
traditional municipal functions.

CDP boundaries may change from one decennial census to the next with changes
in the settlement pattern; a CDP with the same name as in an earlier census
does not necessarily have the same boundary.

CDPs must be contained within a single state and may not extend into an
incorporated place.

There are no population size requirements for CDPs.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch9GARM.pdf}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{county_subdivisions}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{states}()},
\code{\link{tracts}()},
\code{\link{zctas}()}
}
\concept{general area functions}
