% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration_units.R
\name{zctas}
\alias{zctas}
\title{Download a Zip Code Tabulation Area (ZCTA) shapefile into R}
\usage{
zctas(cb = FALSE, starts_with = NULL, year = NULL, state = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
ZCTA file.  Defaults to FALSE (the most detailed TIGER/Line file).
\strong{A warning:} the detailed TIGER/Line ZCTA file is massive
(around 502MB unzipped), and the generalized version is also large
(64MB zipped).  Be prepared for this especially if you have a slower
internet connection.}

\item{starts_with}{Character vector specifying the beginning digits of the
ZCTAs you want to return.  For example, supplying the argument
\code{starts_with = c("75", "76")} will return only those ZCTAs that begin
with 75 or 76.  Defaults to NULL, which will return all ZCTAs in the US.}

\item{year}{the data year; defaults to 2021}

\item{state}{the state for which you are requesting data; only available for 2000 (TIGER/Line
and CB shapefiles) and 2010 (TIGER/Line shapefiles only)}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
ZIP Code Tabulation Areas (ZCTAs) are generalized areal representations of
United States Postal Service (USPS) ZIP Code service areas.  Please see the link provided for
information on how the Census Bureau creates ZCTAs, and for important information on the
differences between ZCTAs and ZIP Codes.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
# Example: get ZCTAs that intersect the Memphis, TN urbanized area

library(tigris)
zcta1 <- zctas(cb = TRUE, starts_with = c("37", "38", "72"))

uas <- urban_areas()

memphis_ua <- uas[grep("Memphis", uas$NAME10), ]

mem_zcta <- zcta1[memphis_ua, ]

plot(mem_zcta$geometry)

}
}
\seealso{
\url{https://www.census.gov/programs-surveys/geography/guidance/geo-areas/zctas.html}

Other general area functions: 
\code{\link{block_groups}()},
\code{\link{blocks}()},
\code{\link{counties}()},
\code{\link{county_subdivisions}()},
\code{\link{places}()},
\code{\link{pumas}()},
\code{\link{school_districts}()},
\code{\link{states}()},
\code{\link{tracts}()}
}
\concept{general area functions}
