% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{tribal_subdivisions_national}
\alias{tribal_subdivisions_national}
\title{Download an American Indian Tribal Subdivision National shapefile into R.}
\usage{
tribal_subdivisions_national(year = NULL, ...)
}
\arguments{
\item{year}{The year for which you'd like to download data (defaults to 2017).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sp"} (the default) or \code{"sf"} to
request sp or sf class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
Definition from the US Census Bureau: "American Indian Tribal Subdivisions (AITS) are legally defined
administrative subdivisions of federally
recognized American Indian reservations and/or off-reservation trust lands or Oklahoma tribal statistical
areas (OTSAs)."  For more information, please see the link provided.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

trib <- tribal_subdivisions_national()
leaflet(trib) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5)
}
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other native/tribal geometries functions: \code{\link{alaska_native_regional_corporations}},
  \code{\link{native_areas}},
  \code{\link{tribal_block_groups}},
  \code{\link{tribal_census_tracts}}
}
\concept{native/tribal geometries functions}
