% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/states.R
\name{states}
\alias{states}
\title{Download shapefile for all states into R}
\usage{
states(cb = FALSE, resolution = "500k", detailed = TRUE, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
states file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{resolution}{The resolution of the cartographic boundary file (if cb == TRUE).
Defaults to '500k'; options include '5m' (1:5 million) and '20m' (1:20 million).}

\item{detailed}{(deprecated) Setting detailed to FALSE returns a 1:500k cartographic boundary file.
This parameter will be removed in a future release.}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}), and \code{year}, the year for which you'd like to download data
(defaults to 2015).}
}
\description{
States and Equivalent Entities are the primary governmental divisions of the
United States.  In addition to the 50 states, the Census Bureau treats the
District of Columbia, Puerto Rico, American Samoa, the Commonwealth of the
Northern Mariana Islands, Guam, and the U.S. Virgin Islands as the statistical
equivalents of states for the purpose of data presentation.
}
\examples{
\dontrun{
library(tigris)
library(leaflet)

states <- states(detailed=FALSE)

leaflet(states) \%>\%
  addProviderTiles("CartoDB.Positron") \%>\%
  addPolygons(fillColor = "white",
              color = "black",
              weight = 0.5) \%>\%
  setView(-98.5795, 39.8282, zoom=3)
}
}
\seealso{
\url{https://www.census.gov/geo/reference/gtc/gtc_state.html}

Other general area functions: \code{\link{block_groups}};
  \code{\link{blocks}}; \code{\link{counties}};
  \code{\link{county_subdivisions}}; \code{\link{places}};
  \code{\link{pumas}}; \code{\link{school_districts}};
  \code{\link{tracts}}; \code{\link{zctas}}
}

