% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence.R
\name{generateEvidence}
\alias{generateEvidence}
\title{Generate evidence}
\usage{
generateEvidence(data, novel, genotype, genotype_db, germline_db,
  fields = NULL)
}
\arguments{
\item{data}{a \code{data.frame} containing sequence data that has been
passed through \link{reassignAlleles} to correct the allele 
assignments.}

\item{novel}{the \code{data.frame} returned by \link{findNovelAlleles}.}

\item{genotype}{the \code{data.frame} of alleles generated with \link{inferGenotype} 
denoting the genotype of the subject.}

\item{genotype_db}{a vector of named nucleotide germline sequences in the genotype.
Returned by \link{genotypeFasta}.}

\item{germline_db}{the original uncorrected germline database used to by
\link{findNovelAlleles} to identify novel alleles.}

\item{fields}{character vector of column names used to split the data to 
identify novel alleles, if any. If \code{NULL} then the data is 
not divided by grouping variables.}
}
\value{
Returns the \code{genotype} input \code{data.frame} with the following additional columns 
providing supporting evidence for each inferred allele:

\itemize{
  \item \code{FIELD_ID}: Data subset identifier, defined with the input paramter \code{fields}.
  \item A variable number of columns, specified with the input parameter \code{fields}.
  \item \code{POLYMORPHISM_CALL}: The novel allele call.
  \item \code{NOVEL_IMGT}: The novel allele sequence.
  \item \code{CLOSEST_REFERENCE}: The closest reference gene and allele in 
        the \code{germline_db} database.
  \item \code{CLOSEST_REFERENCE_IMGT}: Sequence of the closest reference gene and 
        allele in the \code{germline_db} database.
  \item \code{GERMLINE_CALL}: The input (uncorrected) V call.
  \item \code{GERMLINE_IMGT}: Germline sequence for \code{GERMLINE_CALL}.
  \item \code{NT_DIFF}: Number of nucleotides that differ between the new allele and
        the closest reference (\code{CLOSEST_REFERENCE}) in the \code{germline_db} database.
  \item \code{NT_SUBSTITUTIONS}: A comma separated list of specific nucleotide 
        differences (e.g. \code{112G>A}) in the novel allele.
  \item \code{AA_DIFF}: Number of amino acids that differ between the new allele and the closest 
        reference (\code{CLOSEST_REFERENCE}) in the \code{germline_db} database.
  \item \code{AA_SUBSTITUTIONS}: A comma separated list with specific amino acid 
        differences (e.g. \code{96A>N}) in the novel allele.
  \item \code{SEQUENCES}: Number of sequences unambiguosly assigned to this allele.
  \item \code{UNMUTATED_SEQUENCES}: Number of records with the unmutated novel allele sequence.
  \item \code{UNMUTATED_FREQUENCY}: Proportion of records with the unmutated novel allele 
        sequence (\code{UNMUTATED_SEQUENCES / SEQUENCE}).
  \item \code{ALLELIC_PERCENTAGE}: Percentage at which the (unmutated) allele is observed 
        in the sequence dataset compared  to other (unmutated) alleles.
  \item \code{UNIQUE_JS}: Number of unique J sequences found associated with the 
        novel allele. The sequences are those who have been unambiguously assigned 
        to the novel allelle (\code{POLYMORPHISM_CALL}).
  \item \code{UNIQUE_CDR3S}: Number of unique CDR3s associated with the inferred allele.
        The sequences are those who have been unambiguously assigned to the 
        novel allelle (POLYMORPHISM_CALL).
  \item \code{MUT_MIN}: Minimum mutation considered by the algorithm.
  \item \code{MUT_MAX}: Maximum mutation considered by the algorithm.
  \item \code{POS_MIN}: First position of the sequence considered by the algorithm (IMGT numbering).
  \item \code{POS_MAX}: Last position of the sequence considered by the algorithm (IMGT numbering).
  \item \code{Y_INTERCEPT}: The y-intercept above which positions were considered 
        potentially polymorphic.
  \item \code{ALPHA}: Significance threshold to be used when constructing the 
        confidence interval for the y-intercept.
  \item \code{MIN_SEQS}: Input \code{min_seqs}. The minimum number of total sequences 
        (within the desired mutational range and nucleotide range) required 
        for the samples to be considered.
  \item \code{J_MAX}: Input \code{j_max}. The maximum fraction of sequences perfectly 
        aligning to a potential novel allele that are allowed to utilize to a particular 
        combination of junction length and J gene.
  \item \code{MIN_FRAC}: Input \code{min_frac}. The minimum fraction of sequences that must
        have usable nucleotides in a given position for that position to be considered.
  \item \code{NOTE}: Comments regarding the novel allele inferrence.
}
}
\description{
\code{generateEvidence} builds a table of evidence metrics for the final novel V 
allele detection and genotyping inferrences.
}
\examples{
\donttest{
# Generate input data
novel <- findNovelAlleles(SampleDb, GermlineIGHV)
genotype <- inferGenotype(SampleDb, find_unmutated=TRUE, germline_db=GermlineIGHV,
                          novel=novel)
genotype_db <- genotypeFasta(genotype, GermlineIGHV, novel)
data_db <- reassignAlleles(SampleDb, genotype_db)

# Assemble evidence table
evidence <- generateEvidence(data_db, novel, genotype, genotype_db, GermlineIGHV)
}

}
\seealso{
See \link{findNovelAlleles}, \link{inferGenotype} and \link{genotypeFasta} 
for generating the required input.
}
