% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_wikipedia_page_sections.R
\name{tw_write_wikipedia_page_sections_to_cache}
\alias{tw_write_wikipedia_page_sections_to_cache}
\title{Write Wikipedia page links to cache}
\usage{
tw_write_wikipedia_page_sections_to_cache(
  df,
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{df}{A data frame typically generated with \code{tw_get_wikipedia_page_sections()}.}

\item{language}{Defaults to language set with \code{tw_set_language()}; if not set, "en". Use "all_available" to keep all languages. For available language values, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{cache_connection}{Defaults to NULL. If NULL, and caching is enabled, \code{tidywikidatar} will use a local sqlite database. A custom connection to other databases can be given (see vignette \code{caching} for details).}

\item{disconnect_db}{Defaults to TRUE. If FALSE, leaves the connection to cache open.}
}
\value{
Silently returns the same data frame provided as input. Mostly used internally for its side effects.
}
\description{
Mostly used internally by \code{tidywikidatar}, use with caution to keep caching consistent.
}
\examples{
if (interactive()) {
  df <- tw_get_wikipedia_page_sections(
    title = "Margaret Mead",
    language = "en",
    cache = FALSE
  )

  tw_write_wikipedia_page_sections_to_cache(
    df = df,
    language = "en"
  )
}
}
