% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{observed}
\alias{observed}
\alias{observed.data.frame}
\title{observed}
\usage{
observed(o, ...)

\method{observed}{data.frame}(
  o,
  x,
  yobs,
  pred = NULL,
  blq = NULL,
  lloq = -Inf,
  alq = NULL,
  uloq = Inf,
  ...
)
}
\arguments{
\item{o}{data.frame or data.table of observation data}

\item{...}{other arguments}

\item{x}{numeric x-variable, typically named TIME}

\item{yobs}{numeric y-variable, typically named DV}

\item{pred}{population prediction variable, typically named PRED}

\item{blq}{logical variable indicating below limit of quantification}

\item{lloq}{number or numeric variable in data indicating the lower limit of quantification}

\item{alq}{logical variable indicating above limit of quantification}

\item{uloq}{number or numeric variable in data indicating the upper limit of quantification}
}
\value{
A \code{tidyvpcobj} containing both original data and observed data formatted with \code{x} & \code{y} variables as specified in function.
  Resulting data is of class \code{data.frame} and \code{data.table}.
}
\description{
Specify observed dataset and variables for VPC
}
\details{
The observed function is the first function in the vpc piping chain and is used for specifying observed data and variables for VPC. Note: Observed
data must not contain missing DV and may require subsetting \code{MDV == 0} before generating VPC.
}
\examples{
obs_data <- as.data.table(tidyvpc::obs_data)
sim_data <- as.data.table(tidyvpc::sim_data)

obs_data <- obs_data[MDV == 0]
sim_data <- sim_data[MDV == 0]

vpc <- observed(obs_data, x=TIME, y=DV) 

}
\seealso{
\code{\link{simulated}} \code{\link{censoring}} \code{\link{stratify}} \code{\link{predcorrect}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
