% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-posterior-BART.R
\name{fitted_draws_BART}
\alias{fitted_draws_BART}
\title{Get fitted draws from posterior of \code{BART}-package models}
\usage{
fitted_draws_BART(
  model,
  newdata = NULL,
  value = ".value",
  ...,
  include_newdata = TRUE,
  include_sigsqs = FALSE,
  scale = "real"
)
}
\arguments{
\item{model}{A model from \code{BART} package.}

\item{newdata}{Data frame to generate fitted values from. If omitted, defaults to the data used to fit the model.}

\item{value}{The name of the output column for \code{fitted_draws}; default \code{".value"}.}

\item{...}{Arguments to pass to \code{predict} (e.g. \code{BART:::predict.wbart}).}

\item{include_newdata}{Should the newdata be included in the tibble?}

\item{include_sigsqs}{Should the posterior sigma-squared draw be included?}

\item{scale}{Should the fitted values be on the real, probit or logit scale?}
}
\value{
A tidy data frame (tibble) with fitted values.
}
\description{
Get fitted draws from posterior of \code{BART}-package models
}
