% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_by.R
\name{nest_by.}
\alias{nest_by.}
\title{Nest data.tables}
\usage{
nest_by.(.df, ..., .key = "data", .keep = FALSE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group by. If empty nests the entire data.table.
\code{tidyselect} compatible.}

\item{.key}{Name of the new column created by nesting.}

\item{.keep}{Should the grouping columns be kept in the list column.}
}
\description{
Nest data.tables by group
}
\examples{
df <- data.table(
  a = 1:5,
  b = 6:10,
  c = c(rep("a", 3), rep("b", 2)),
  d = c(rep("a", 3), rep("b", 2))
)

df \%>\%
  nest_by.()

df \%>\%
  nest_by.(c, d)

df \%>\%
  nest_by.(where(is.character))

df \%>\%
  nest_by.(c, d, .keep = TRUE)
}
