% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmute.R
\name{transmute}
\alias{transmute}
\title{Add new variables and drop all others}
\usage{
transmute(.df, ..., .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to create/modify}

\item{.by}{Columns to group by}
}
\description{
Unlike \code{mutate()}, \code{transmute()} keeps only the variables that you create
}
\examples{
df <- data.table(
  a = 1:3,
  b = 4:6,
  c = c("a", "a", "b")
)

df \%>\%
  transmute(double_a = a * 2)
}
