% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_when.R
\name{case_when}
\alias{case_when}
\title{Case when}
\usage{
case_when(..., .default = NA, .ptype = NULL, .size = NULL)
}
\arguments{
\item{...}{A sequence of two-sided formulas. The left hand side gives the conditions,
the right hand side gives the values.}

\item{.default}{The default value if all conditions evaluate to \code{FALSE}.}

\item{.ptype}{Optional ptype to specify the output type.}

\item{.size}{Optional size to specify the output size.}
}
\description{
This function allows you to use multiple if/else statements in one call.

It is called like \code{dplyr::case_when()}, but utilizes \code{data.table::fifelse()}
in the background for improved performance.
}
\examples{
df <- tidytable(x = 1:10)

df \%>\%
  mutate(case_x = case_when(x < 5 ~ 1,
                            x < 7 ~ 2,
                            TRUE ~ 3))
}
