% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart.R
\name{tidyRules.rpart}
\alias{tidyRules.rpart}
\title{Obtain rules as a tidy tibble from a rpart model}
\usage{
\method{tidyRules}{rpart}(object, ...)
}
\arguments{
\item{object}{Fitted model object with rules}

\item{...}{Other arguments (currently unused)}
}
\value{
A tibble where each row corresponds to a rule. The columns are:
  support, confidence, lift, LHS, RHS
}
\description{
Each row corresponds to a rule. A rule can be copied into
  `dplyr::filter` to filter the observations corresponding to a rule
}
\details{
NOTE: For rpart rules, one should build the model without
\bold{ordered factor} variable. We recommend you to convert \bold{ordered
factor} to \bold{factor} or \bold{integer} class.
}
\examples{
iris_rpart <- rpart::rpart(Species ~ .,data = iris)
tidyRules(iris_rpart)
}
\author{
Amith Kumar U R, \email{amith54@gmail.com}
}
