% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_ndr.R
\name{summarise_ndr}
\alias{summarise_ndr}
\title{Count the Number of Outcomes Based on a Specified Level}
\usage{
summarise_ndr(..., level, names)
}
\arguments{
\item{...}{Data frames to be summarised.}

\item{level}{The level at which the summary should be performed. The options
are "ip" (or "country"), "state", "lga" or "facility".}

\item{names}{The names to be passed to the summary columns created in
the output}
}
\value{
summarise_ndr
}
\description{
The \code{summarise_ndr()} function counts the number of occurrence of
specified level for each of the supplied dataframe. It then combines the
given dataframes into a single table. It also adds a "Total" roll that
adds all the rows for each of the numeric columns.
}
\examples{
new <- tx_new(ndr_example)
curr <- tx_curr(ndr_example)

summarise_ndr(
  new,
  curr,
  level = "state",
  names = c("tx_new", "tx_curr")
)

### summarise for only one dataframe
summarise_ndr(
  data = new,
  level = "ip",
  names = "tx_new"
)
}
