% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hy_daily.R
\name{hy_daily}
\alias{hy_daily}
\title{Extract all daily water level and flow measurements}
\format{A tibble with 5 variables:
\describe{
  \item{STATION_NUMBER}{Unique 7 digit Water Survey of Canada station number}
  \item{Date}{Observation date. Formatted as a Date class.}
  \item{Parameter}{Parameter being measured.}
  \item{Value}{Discharge value. The units are m^3/s.}
  \item{Symbol}{Measurement/river conditions}
}}
\source{
HYDAT
}
\usage{
hy_daily(
  station_number = NULL,
  prov_terr_state_loc = NULL,
  hydat_path = NULL,
  ...
)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}. Will also accept \code{CA} to return only Canadian stations.}

\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing 
\link[dplyr]{src_sqlite} such that the database only needs to be opened once per
user-level call.}

\item{...}{See \code{\link{hy_daily_flows}} arguments}
}
\value{
A tibble of daily flows and levels
}
\description{
A thin wrapper around \code{hy_daily_flows} and \code{hy_daily_levels} that returns a data frames that 
contains both parameters. All arguments are passed directly to these functions.
}
\examples{
\dontrun{
hy_daily(station_number = c("02JE013","08MF005"))
}
}
\seealso{
Other HYDAT functions: 
\code{\link{hy_agency_list}()},
\code{\link{hy_annual_instant_peaks}()},
\code{\link{hy_annual_stats}()},
\code{\link{hy_daily_flows}()},
\code{\link{hy_daily_levels}()},
\code{\link{hy_data_symbols}},
\code{\link{hy_data_types}},
\code{\link{hy_datum_list}()},
\code{\link{hy_monthly_flows}()},
\code{\link{hy_monthly_levels}()},
\code{\link{hy_reg_office_list}()},
\code{\link{hy_sed_daily_loads}()},
\code{\link{hy_sed_daily_suscon}()},
\code{\link{hy_sed_monthly_loads}()},
\code{\link{hy_sed_monthly_suscon}()},
\code{\link{hy_sed_samples_psd}()},
\code{\link{hy_sed_samples}()},
\code{\link{hy_stations}()},
\code{\link{hy_stn_data_coll}()},
\code{\link{hy_stn_data_range}()},
\code{\link{hy_stn_op_schedule}()},
\code{\link{hy_stn_regulation}()},
\code{\link{hy_version}()}
}
\concept{HYDAT functions}
