% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{geo}
\alias{geo}
\title{Geocode addresses}
\usage{
geo(
  address = NULL,
  street = NULL,
  city = NULL,
  county = NULL,
  state = NULL,
  postalcode = NULL,
  country = NULL,
  method = "census",
  cascade_order = c("census", "osm"),
  lat = lat,
  long = long,
  limit = 1,
  min_time = NULL,
  api_url = NULL,
  timeout = 20,
  mode = "",
  full_results = FALSE,
  unique_only = FALSE,
  return_addresses = TRUE,
  flatten = TRUE,
  batch_limit = 10000,
  verbose = FALSE,
  no_query = FALSE,
  custom_query = list(),
  return_type = "locations",
  iq_region = "us",
  geocodio_v = 1.6
)
}
\arguments{
\item{address}{single line address (ie. '1600 Pennsylvania Ave NW, Washington, DC').
Do not combine with the address component arguments below
(street, city, county, state, postalcode, country).}

\item{street}{street address (ie. '1600 Pennsylvania Ave NW')}

\item{city}{city (ie. 'Tokyo')}

\item{county}{county (ie. 'Jefferson')}

\item{state}{state (ie. 'Kentucky')}

\item{postalcode}{postalcode (zip code if in the United States)}

\item{country}{country (ie. 'Japan')}

\item{method}{the geocoder service to be used. Refer to 
\code{\link{api_parameter_reference}} and the API documentation for
each geocoder service for usage details and limitations.
\itemize{
  \item \code{"census"}: US Census Geocoder. US street-level addresses only. 
     Can perform batch geocoding.
  \item \code{"osm"}: Nominatim (OSM). Worldwide coverage.
  \item \code{"geocodio"}: Commercial geocoder. Covers US and Canada and has
     batch geocoding capabilities. Requires an API Key to be stored in
     the "GEOCODIO_API_KEY" environmental variable.
  \item \code{"iq"}: Commercial Nominatim geocoder service. Requires an API Key to
     be stored in the "LOCATIONIQ_API_KEY" environmental variable.
  \item \code{"cascade"} : Attempts to use one geocoder service and then uses
    a second geocoder service if the first service didn't return results.
    The services and order is specified by the cascade_order argument. 
    Note that this is not compatible with \code{full_results = TRUE} as geocoder
    services have different columns that they return.
}}

\item{cascade_order}{a vector with two character values for the method argument 
in the order in which the geocoder services will be attempted for method = "cascade"
(ie. \code{c('census', 'geocodio')})}

\item{lat}{latitude column name. Can be quoted or unquoted (ie. lat or 'lat').}

\item{long}{longitude column name. Can be quoted or unquoted (ie. long or 'long').}

\item{limit}{number of results to return per address. Note that 
limit > 1 is not compatible with batch geocoding if return_addresses = TRUE.}

\item{min_time}{minimum amount of time for a query to take (in seconds) if using
Location IQ or OSM. This parameter is used to abide by API usage limits. You can
set it to a lower value (ie. 0) if using a local Nominatim server, for instance.}

\item{api_url}{custom API URL. If specified, the default API URL will be overridden.
This can be used to specify a local Nominatim server.}

\item{timeout}{query timeout (in minutes)}

\item{mode}{set to 'batch' to force batch geocoding or 'single' to 
force single address geocoding (one address per query). If not 
specified then batch geocoding will be used if available
(given method selected) when multiple addresses are provided, otherwise
single address geocoding will be used.}

\item{full_results}{returns all data from the geocoder service if TRUE. 
If FALSE then only longitude and latitude are returned from the geocoder service.}

\item{unique_only}{only return results for unique addresses if TRUE}

\item{return_addresses}{return input addresses with results if TRUE}

\item{flatten}{if TRUE then any nested dataframes in results are flattened if possible.
Note that Geocodio batch geocoding results are flattened regardless.}

\item{batch_limit}{limit to the number of addresses in a batch geocoding query.
Both geocodio and census batch geocoders have a 10,000 address limit so this
is the default.}

\item{verbose}{if TRUE then detailed logs are output to the console}

\item{no_query}{if TRUE then no queries are sent to the geocoder and verbose is set to TRUE}

\item{custom_query}{API-specific parameters to be used, passed as a named list 
(ie. \code{list(vintage = 'Current_Census2010')}).}

\item{return_type}{only used when method = 'census'. Two possible values: 
\itemize{
    \item \code{"locations"} (default)
    \item \code{"geographies"}: returns additional geography columns. 
    See the Census geocoder API documentation for more details.
}}

\item{iq_region}{'us' (default) or 'eu'. Used for establishing API URL for the 'iq' method}

\item{geocodio_v}{version of geocodio api. 1.6 is default. Used for establishing API URL
for the 'geocodio' method.}
}
\value{
parsed geocoding results in tibble format
}
\description{
Geocodes addresses given as character values. The \code{\link{geocode}}
function utilizes this function on addresses contained in dataframes.
See example usage in \code{vignette("tidygeocoder")} 

Note that not all geocoder services support certain address component 
parameters. For example, the Census geocoder only covers the United States 
and does not have a "country" parameter. Refer to \code{\link{api_parameter_reference}} 
for more details on geocoder services and API usage. 

This function uses the \code{\link{get_api_query}}, \code{\link{query_api}}, and
\code{\link{extract_results}} functions to create, execute, and parse the geocoder
API queries.
}
\examples{
\donttest{
geo(street = "600 Peachtree Street NE", city = "Atlanta",
 state = "Georgia", method = "census")

geo(address = c("Tokyo, Japan", "Lima, Peru", "Nairobi, Kenya"),
 method = 'osm')

geo(county = 'Jefferson', state = "Kentucky", country = "US",
     method = 'osm')
}
}
\seealso{
\code{\link{geocode}} \code{\link{api_parameter_reference}}
}
