% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{separate_dt}
\alias{separate_dt}
\title{Separate a character column into two columns using
a regular expression separator}
\usage{
separate_dt(
  .data,
  separated_colname,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE
)
}
\arguments{
\item{.data}{A data frame.}

\item{separated_colname}{Column name, string only.}

\item{into}{Character vector of length 2.}

\item{sep}{Separator between columns.}

\item{remove}{If \code{TRUE}, remove input column from output data frame.}
}
\description{
Given either regular expression,
\code{separate_dt()} turns a single character column into two columns.
}
\examples{
df <- data.frame(x = c(NA, "a.b", "a.d", "b.c"))
df \%>\% separate_dt(x, c("A", "B"))
# equals to
df \%>\% separate_dt("x", c("A", "B"))

# If you just want the second variable:
df \%>\% separate_dt(x,into = c(NA,"B"))
}
\seealso{
\code{\link[tidyr]{separate}}, \code{\link[tidyfst]{unite_dt}}
}
