% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_when.R
\name{dt_case_when}
\alias{dt_case_when}
\title{Case When with data.table}
\usage{
dt_case_when(...)
}
\arguments{
\item{...}{statements of the form: \code{condition ~ label}, where the label is applied if the condition is met}
}
\value{
Vector of the same size as the input vector
}
\description{
Does what \code{dplyr::case_when()} does, with the same syntax, but with
\code{data.table::fifelse()} under the hood
}
\examples{

x <- rnorm(100)
dt_case_when(
  x < median(x) ~ "low",
  x >= median(x) ~ "high",
  is.na(x) ~ "other"
  )

library(data.table)
temp <- data.table(pseudo_id = c(1, 2, 3, 4, 5),
                   x = sample(1:5, 5, replace = TRUE))
temp[, y := dt_case_when(pseudo_id == 1 ~ x * 1,
                         pseudo_id == 2 ~ x * 2,
                         pseudo_id == 3 ~ x * 3,
                         pseudo_id == 4 ~ x * 4,
                         pseudo_id == 5 ~ x * 5)]

}
