% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icr_kappa.R
\name{icr_brennan_prediger}
\alias{icr_brennan_prediger}
\title{Compute Brennan & Prediger's Kappa}
\usage{
icr_brennan_prediger(ucm)
}
\arguments{
\item{ucm}{Units-coders matrix}
}
\description{
Computes Brennan & Prediger's Kappa (extension to 3+ coders as proposed by
von Eye (2006).
}
\references{
Brennan, R. L., & Prediger, D. J. (1981). Coefficient Kappa: Some
uses, misuses, and alternatives. Educational and Psychological Measurement,
41(3), 687-699. https://doi.org/10.1177/001316448104100307

von Eye, A. (2006). An Alternative to Cohen's Kappa. European Psychologist, 11(1),
12-24. https://doi.org/10.1027/1016-9040.11.1.12
}
\seealso{
Other intercoder reliability: \code{\link{compute_icr}},
  \code{\link{icr_agreement}},
  \code{\link{icr_cohens_kappa}},
  \code{\link{icr_fleiss_kappa}},
  \code{\link{icr_holstis_CR}},
  \code{\link{icr_kripp_alpha}}, \code{\link{test_icr}},
  \code{\link{unit_coder_matrix}}
}
\concept{intercoder reliability}
