% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_time_series.R
\name{parse_time_series}
\alias{parse_time_series}
\title{Function to transfer data frame with time series values in wide format to format accepted by `line_chart_dense_custom`.}
\usage{
parse_time_series(df, dates, series, convert.to = "months")
}
\arguments{
\item{df}{Date frame with data in wide format.}

\item{dates}{Name of column in `df` which contains dates.}

\item{series}{Vector of column names in `df` with values of time series.}

\item{convert.to}{Granularity of x axis. One of c('weeks', 'months', 'quarters', 'years'). Default value is 'months'.}
}
\value{
list of data frames, each one containing data about one time series.  Data frames in returned list consist of columns:
* containing numeric values from 0 to 100 defining the percentage of distance in one time interval of the point (x - coordinattes of the point)
* containing the value of a point  (y - coordinates of the point)
* containing the time interval of the value
}
\description{
Function to transfer data frame with time series values in wide format to format accepted by `line_chart_dense_custom`.
}
\examples{
df <- data.frame(
    dates = as.Date(c('2021-07-12', '2021-06-18', '2021-05-12')),
    val1 = c(1.5, 1.2, 2.1),
    val2 = c(0.9, 3.2, 1.1))
parse_time_series(df, 'dates', c('val1', 'val2'))
}
