% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_chart.R
\name{bar_chart_normalized}
\alias{bar_chart_normalized}
\title{Generates normalized horizontal barchart. If more than one series is supplied, stacked barchart is generated.}
\usage{
bar_chart_normalized(data, cat, series, series_labels = series)
}
\arguments{
\item{data}{data frame containing data to be plotted}

\item{cat}{vector cointaining category names of values}

\item{series}{vector containing names of columns in data with values to plot}

\item{series_labels}{vector containing names of series to be shown on the plot}
}
\value{
SVG string containing chart
}
\description{
Generates normalized horizontal barchart. If more than one series is supplied, stacked barchart is generated.
}
\examples{
#prepare the data frame
data <- data.frame(
city = c("Berlin", "Munich", "Cologne", "London", "Vienna", "Paris", "Zurich"),
Products = c(538, 250, 75, 301, 227, 100, 40),
Services = c(621, 545, 302, 44, 39, 20, 34)
)
#create svg string
barchart_normalized <- bar_chart_normalized(
  data = data,
  cat = data$city,
  series = c("Products", "Services"))

#show the plot
barchart_normalized \%>\% SVGrenderer()

}
