% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_categorical.R
\name{tidy_categorical}
\alias{tidy_categorical}
\title{Expand broom::tidy() Outputs for Categorical Parameter Estimates}
\usage{
tidy_categorical(
  d,
  m,
  exclude_reference = TRUE,
  reference_label = NULL,
  exponentiate = FALSE
)
}
\arguments{
\item{d}{A data frame \link[tibble:tibble]{tibble::tibble()} output from \link[broom:tidy.lm]{broom::tidy.lm()}; with one row for each term in the regression, including column `term`}

\item{m}{A model object, created using a function such as \link[stats:lm]{stats::lm()}}

\item{exclude_reference}{Logical indicating to include additional rows in output for reference categories, obtained from \link[stats:dummy.coef]{stats::dummy.coef()}. Defaults to `TRUE`}

\item{reference_label}{Character string. When used will create an additional column in output with labels to indicate if terms correspond to reference categories or not.}

\item{exponentiate}{Logical indicating whether or not the results in \link[broom:tidy.lm]{broom::tidy.lm()} are exponentiated. Defaults to `FALSE`.}
}
\value{
Expanded \link[tibble:tibble]{tibble::tibble()} from the version passed to `d` including additional columns:
\item{variable}{The name of the variable that the regression term belongs to.}
\item{level}{The level of the categorical variable that the regression term belongs to. Will be an empty string for numeric variables.}
\item{effect}{The type of term (`main` or `interaction`)}
\item{reference}{The type of term (`reference` or `non-reference`) with label passed from `reference_label`. If `reference_label` is set `NULL` (default) will not be created.}
In addition, extra rows will be added, if `exclude_reference` is set to `FALSE` for the reference categories, obtained from \link[stats:dummy.coef]{stats::dummy.coef()}
}
\description{
Create additional columns in a tidy model output (such as \link[broom:tidy.lm]{broom::tidy.lm()}) to allow for easier control when plotting categorical parameter estimates.
}
\examples{
# strip ordering in factors (currently ordered factor not supported)
library(dplyr)
library(broom)

m0 <- esoph \%>\%
  mutate_if(is.factor, ~factor(., ordered = FALSE)) \%>\%
  glm(cbind(ncases, ncontrols) ~ agegp + tobgp * alcgp, data = .,
        family = binomial())
# tidy
tidy(m0)

# add further columns to tidy output to help manage categorical variables
m0 \%>\%
 tidy() \%>\%
 tidy_categorical(m = m0)

# include reference categories and column to indicate the additional terms
m0 \%>\%
 tidy() \%>\%
 tidy_categorical(m = m0, exclude_reference = FALSE, reference_label = "Reference")

# coefficient plots
d0 <- m0 \%>\%
  tidy(conf.int = TRUE) \%>\%
  tidy_categorical(m = m0, exclude_reference = FALSE, reference_label = "Baseline") \%>\%
  # drop the intercept term
  slice(-1)
d0

# typical coefficient plot
library(ggplot2)
library(tidyr)
ggplot(data = d0 \%>\% drop_na(),
       mapping = aes(x = term, y = estimate,
                     ymin = conf.low, ymax = conf.high)) +
  coord_flip() +
  geom_hline(yintercept = 0, linetype = "dashed") +
  geom_pointrange()

# enhanced coefficient plot using additional columns from tidy_categroical and ggforce::facet_row()
library(ggforce)
ggplot(data = d0,
       mapping = aes(x = level, colour = reference,
                     y = estimate, ymin = conf.low, ymax = conf.high)) +
  facet_row(facets = vars(variable), scales = "free_x", space = "free") +
  geom_hline(yintercept = 0, linetype = "dashed") +
  geom_pointrange() +
  theme(axis.text.x = element_text(angle = 45, hjust = 1))
}
\seealso{
\link[broom:tidy.lm]{broom::tidy.lm()}
}
