% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose_data.R
\name{compose_data}
\alias{compose_data}
\title{Compose data for input into a Bayesian model}
\usage{
compose_data(..., .n_name = n_prefix("n"))
}
\arguments{
\item{...}{Data to be composed into a list suitable for being passed into
Stan, JAGS, etc. Named arguments will have their name used as the \code{name}
argument to \code{as_data_list} when translated; unnamed arguments that are
not lists or data frames will have their bare value (passed through
\code{make.names}) used as the \code{name} argument to \code{as_data_list}.
Each argument is evaluated using \code{eval_tidy} in an environment that
includes all list items composed so far.}

\item{.n_name}{A function that is used to form dimension index variables (a variable
whose value is number of levels in a factor or the length of a data frame in
\code{...}). For example, if a data frame with 20 rows and a factor \code{"foo"}
(having 3 levels) is passed to \code{compose_data}, the list returned by
\code{compose_data} will include an element named \code{.n_name("foo")}, which
by default would be "n_foo", containing the value 3, and a column named "n"
containing the value 20. See \code{\link[=n_prefix]{n_prefix()}}.}
}
\value{
A list where each element is a translated variable as described above.
}
\description{
Compose data into a list suitable to be passed into a Bayesian model (JAGS,
BUGS, Stan, etc).
}
\details{
This function recursively translates each argument into list elements using
\code{\link[=as_data_list]{as_data_list()}}, merging all resulting lists together. By
default this means that:
\itemize{
\item numerics are included as-is.
\item logicals are translated into numeric using \code{\link[=as.numeric]{as.numeric()}}.
\item factors are translated into numeric using \code{\link[=as.numeric]{as.numeric()}},
and an additional element named \code{.n_name(argument_name)} is added
with the number of levels in the factor. The default \code{.n_name}
function prefixes \code{"n_"} before the factor name; e.g. a factor
named \code{foo} will have an element named \code{n_foo} added containing
the number of levels in \code{foo}.
\item character vectors are converted into factors then translated into numeric
in the same manner as factors are.
\item lists are translated by translating all elements of the list
(recursively) and adding them to the result.
\item data.frames are translated by translating every column of the data.frame
and adding them to the result.  A variable named \code{"n"} (or
\code{.n_name(argument_name)} if the data.frame is passed as a named
argument \code{argument_name}) is also added containing the number of rows
in the data frame.
\item \code{NULL} values are dropped. Setting a named argument to \code{NULL}
can be used to drop that item from the resulting list (if an unwanted
element was added to the list by a previous argument, such as a column
from a data frame that is not needed in the model).
\item all other types are dropped (and a warning given)
}

As in functions like \code{\link[=mutate]{mutate()}}, each expression is evaluated in an
environment containing the data list built up so far.

For example, this means that if the first argument to \code{compose_data}
is a data frame, subsequent arguments can include direct references to columns
from that data frame. This allows you, for example, to easily use
\code{\link[=x_at_y]{x_at_y()}} to generate indices for nested models.

If you wish to add support for additional types not described above,
provide an implementation of \code{\link[=as_data_list]{as_data_list()}} for the type. See
the implementations of \code{as_data_list.numeric},
\code{as_data_list.logical}, etc for examples.
}
\examples{

library(magrittr)

df = data.frame(
  plot = factor(paste0("p", rep(1:8, times = 2))),
  site = factor(paste0("s", rep(1:4, each = 2, times = 2)))
)

# without changing `.n_name`, compose_data() will prefix indices
# with "n" by default
df \%>\%
  compose_data()

# you can use n_prefix() to define a different prefix (e.g. "N"):
df \%>\%
  compose_data(.n_name = n_prefix("N"))

# If you have nesting, you may want a nested index, which can be generated using x_at_y()
# Here, site[p] will give the site for plot p
df \%>\%
  compose_data(site = x_at_y(site, plot))

}
\seealso{
\code{\link[=x_at_y]{x_at_y()}}, \code{\link[=spread_draws]{spread_draws()}},
\code{\link[=gather_draws]{gather_draws()}}.
}
\author{
Matthew Kay
}
\keyword{manip}
