% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_expr_template.R
\name{bf_expr_template}
\alias{bf_expr_template}
\title{Expression template for Bayes Factor results}
\usage{
bf_expr_template(
  top.text,
  prior.type = quote(italic("r")["Cauchy"]^"JZS"),
  estimate.type = quote(delta),
  estimate.df,
  centrality = "median",
  conf.level = 0.95,
  conf.method = "HDI",
  k = 2L,
  ...
)
}
\arguments{
\item{top.text}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}

\item{prior.type}{A character that specifies the prior type.}

\item{estimate.type}{A character that specifies the relevant effect size.}

\item{estimate.df}{Dataframe containing estimates and their credible
intervals along with Bayes Factor value. The columns should be named as
\code{estimate}, \code{estimate.LB}, \code{estimate.UB}, and \code{bf10}.}

\item{centrality}{The point-estimates (centrality indices) to compute.
Character (vector) or list with one or more of these options: \code{"median"},
\code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{conf.level}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}

\item{conf.method}{The type of index used for Credible Interval. Can be
\code{"hdi"} (default), \code{"eti"}, or \code{"si"} (see \code{si()}, \code{hdi()}, \code{eti()}
functions from \code{bayestestR} package).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{...}{Currently ignored.}
}
\description{
Expression template for Bayes Factor results
}
