% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tib_spec.R
\name{tib_unspecified}
\alias{tib_unspecified}
\alias{tib_scalar}
\alias{tib_lgl}
\alias{tib_int}
\alias{tib_dbl}
\alias{tib_chr}
\alias{tib_date}
\alias{tib_chr_date}
\alias{tib_vector}
\alias{tib_lgl_vec}
\alias{tib_int_vec}
\alias{tib_dbl_vec}
\alias{tib_chr_vec}
\alias{tib_date_vec}
\alias{tib_chr_date_vec}
\alias{tib_variant}
\alias{tib_row}
\alias{tib_df}
\title{Create a Field Specification}
\usage{
tib_unspecified(key, ..., required = TRUE)

tib_scalar(
  key,
  ptype,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = ptype,
  transform = NULL
)

tib_lgl(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = logical(),
  transform = NULL
)

tib_int(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = integer(),
  transform = NULL
)

tib_dbl(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = double(),
  transform = NULL
)

tib_chr(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = character(),
  transform = NULL
)

tib_date(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = vctrs::new_date(),
  transform = NULL
)

tib_chr_date(key, ..., required = TRUE, fill = NULL, format = "\%Y-\%m-\%d")

tib_vector(
  key,
  ptype,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = ptype,
  transform = NULL,
  input_form = c("vector", "scalar_list", "object"),
  values_to = NULL,
  names_to = NULL
)

tib_lgl_vec(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = logical(),
  transform = NULL,
  input_form = c("vector", "scalar_list", "object"),
  values_to = NULL,
  names_to = NULL
)

tib_int_vec(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = integer(),
  transform = NULL,
  input_form = c("vector", "scalar_list", "object"),
  values_to = NULL,
  names_to = NULL
)

tib_dbl_vec(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = double(),
  transform = NULL,
  input_form = c("vector", "scalar_list", "object"),
  values_to = NULL,
  names_to = NULL
)

tib_chr_vec(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = character(),
  transform = NULL,
  input_form = c("vector", "scalar_list", "object"),
  values_to = NULL,
  names_to = NULL
)

tib_date_vec(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  ptype_inner = vctrs::new_date(),
  transform = NULL,
  input_form = c("vector", "scalar_list", "object"),
  values_to = NULL,
  names_to = NULL
)

tib_chr_date_vec(
  key,
  ...,
  required = TRUE,
  fill = NULL,
  input_form = c("vector", "scalar_list", "object"),
  values_to = NULL,
  names_to = NULL,
  format = "\%Y-\%m-\%d"
)

tib_variant(key, ..., required = TRUE, fill = NULL, transform = NULL)

tib_row(.key, ..., .required = TRUE)

tib_df(.key, ..., .required = TRUE, .names_to = NULL)
}
\arguments{
\item{key, .key}{The path to the field in the object.}

\item{...}{These dots are for future extensions and must be empty.}

\item{required, .required}{Throw an error if the field does not exist?}

\item{ptype}{A prototype of the desired output type of the field.}

\item{fill}{Optionally, a value to use if the field does not exist.}

\item{ptype_inner}{A prototype of the field.}

\item{transform}{A function to apply after casting to \code{ptype_inner}.
When exactly it is applied depends on the field type:
\itemize{
\item \code{tib_scalar()} it is applied to the column.
\item \code{tib_vector()}, \code{tib_variant()} it is applied to each element of the column.
}}

\item{format}{Optional, a string passed to the \code{format} argument of \code{as.Date()}.}

\item{input_form}{A string that describes what structure the field has. Can
be one of:
\itemize{
\item \code{"vector"}: The field is a vector, e.g. \code{c(1, 2, 3)}.
\item \code{"scalar_list"}: The field is a list of scalars, e.g. \code{list(1, 2, 3)}.
\item \code{"object"}: The field is a named list of scalars, e.g. \code{list(a = 1, b = 2, c = 3)}.
}}

\item{values_to}{Can be one of the following:
\itemize{
\item \code{NULL}: the default. The field is converted to a \code{ptype} vector.
\item A string: The field is converted to a tibble and the values go into the
specified column.
}}

\item{names_to}{Can be one of the following:
\itemize{
\item \code{NULL}: the default. The inner names of the field are not used.
\item A string: This can only be used if 1) for the input form is \code{"object"}
or \code{"vector"} and 2) \code{values_to} is a string. The inner names of the
field go into the specified column.
}}

\item{.names_to}{A string giving the name of the column which will contain
the names of elements of the object list. If \code{NULL}, the default, no name
column is created}
}
\value{
A tibblify field collector.
}
\description{
Use these functions to specify how to convert the fields of an object.
}
\details{
There are basically five different \verb{tib_*()} functions
\itemize{
\item \code{tib_scalar(ptype)}: Cast the field to a length one vector of type \code{ptype}.
\item \code{tib_vector(ptype)}: Cast the field to an arbitrary length vector of type \code{ptype}.
\item \code{tib_variant()}: Cast the field to a list.
\item \code{tib_row()}: Cast the field to a named list.
\item \code{tib_df()}: Cast the field to a tibble.
}

There are some special shortcuts of \code{tib_scalar()} resp. \code{tib_vector()} for
the most common prototypes
\itemize{
\item \code{logical()}: \code{tib_lgl()} resp. \code{tib_lgl_vec()}
\item \code{integer()}: \code{tib_int()} resp. \code{tib_int_vec()}
\item \code{double()}: \code{tib_dbl()} resp. \code{tib_dbl_vec()}
\item \code{character()}: \code{tib_chr()} resp. \code{tib_chr_vec()}
\item \code{Date}: \code{tib_date()} resp. \code{tib_date_vec()}
}

Further, there is also a special shortcut for dates encoded as character:
\code{tib_chr_date()} resp. \code{tib_chr_date_vec()}.
}
\examples{
tib_int("int")
tib_int("int", required = FALSE, fill = 0)

tib_scalar("date", Sys.Date(), transform = function(x) as.Date(x, format = "\%Y-\%m-\%d"))

tib_df(
  "data",
  .names_to = "id",
  age = tib_int("age"),
  name = tib_chr("name")
)
}
