% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.topics}
\alias{predict.topics}
\alias{predict_functions}
\alias{predict.functions}
\alias{predict_topics}
\title{Predict topic functional content}
\usage{
\method{predict}{topics}(object, reference = c("gg_ko", "gg_cog", "silva_ko"),
  reference_path, scalar = 100, cn_normalize = FALSE,
  sample_normalize = FALSE, drop = TRUE, ...)
}
\arguments{
\item{object}{(required) Output of \code{\link{find_topics}}.}

\item{reference}{A string for either gg_ko, gg_cog, or silva_ko.
Defaults to gg_ko.}

\item{reference_path}{Folder path of the reference file}

\item{scalar}{Value for scaling the topics over taxa distrubution
to predicted counts. Defaults to 100.}

\item{cn_normalize}{Logical flag for performing 16S rRNA copy number
normalization. Defaults to FALSE.}

\item{sample_normalize}{Logical flag to normalize functional
predictions by the total functional abundance in a sample.
Defaults to FALSE.}

\item{drop}{Logical flag to drop empty gene columns. Defaults to TRUE.}

\item{...}{Additional arguments for t4f method.}
}
\value{
An object of class functions containing
\describe{
\item{fxn_table}{A matrix of gene counts across topics.}
\item{fxn_meta}{A list of functional metadata corresponding to fxn_table.}
\item{method_meta}{A matrix of method specific metadata.}
}
}
\description{
Given an object of class topics, this function predicts the functional
content using PICRUSt or tax4fun precalculated mapping tables that maps
the taxonomic abundance for a given OTU to functional abundance content
across a set of functional genes.
}
\examples{
formula <- ~DIAGNOSIS
refs <- 'Not IBD'

dat <- prepare_data(otu_table=GEVERS$OTU,rows_are_taxa=FALSE,tax_table=GEVERS$TAX,
                    metadata=GEVERS$META,formula=formula,refs=refs,
                    cn_normalize=TRUE,drop=TRUE)

\dontrun{
topics <- find_topics(dat,K=15)

download_ref(destination='/references',reference='gg_ko')
functions <- predict(topics,reference='gg_ko',
                     reference_path='/references')
}

}
\references{
ABhauer, K. P., Wemheuer, B. Daniel, R., and Meinicke, P. (2015).
Bioinformatics, 1-3. 31(17).

Langille, M. G.I.*, Zaneveld, J.*, Caporaso, J. G., McDonald, D., Knights, D.,
a Reyes, J., Clemente, J. C., Burkepile, D. E., Vega Thurber, R. L., Knight, R.,
Beiko, R. G., and Huttenhower, C. (2013). Nature Biotechnology, 1-10. 8.
}
\seealso{
\code{\link{download_ref}} \code{\link{picrust}} \code{\link{t4f}}
}
