% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_estimator.R
\name{estimators}
\alias{estimators}
\title{Base Documentation for Canned Estimators}
\arguments{
\item{object}{A TensorFlow estimator.}

\item{feature_columns}{An \R list containing all of the feature columns used
by the model (typically, generated by \code{\link[=feature_columns]{feature_columns()}}).}

\item{model_dir}{Directory to save the model parameters, graph, and so on.
This can also be used to load checkpoints from the directory into a
estimator to continue training a previously saved model.}

\item{label_dimension}{Number of regression targets per example. This is the
size of the last dimension of the labels and logits \code{Tensor} objects
(typically, these have shape \verb{[batch_size, label_dimension]}).}

\item{label_vocabulary}{A list of strings represents possible label values.
If given, labels must be string type and have any value in
\code{label_vocabulary}. If it is not given, that means labels are already
encoded as integer or float within \verb{[0, 1]} for \code{n_classes == 2} and
encoded as integer values in \verb{\{0, 1,..., n_classes  -1\}} for \code{n_classes > 2}. Also there will be errors if vocabulary is not provided and labels are
string.}

\item{weight_column}{A string, or a numeric column created by
\code{\link[=column_numeric]{column_numeric()}} defining feature column representing weights. It is used
to down weight or boost examples during training. It will be multiplied by
the loss of the example. If it is a string, it is used as a key to fetch
weight tensor from the \code{features} argument. If it is a numeric column,
then the raw tensor is fetched by key \code{weight_column$key}, then
\code{weight_column$normalizer_fn} is applied on it to get weight tensor.}

\item{n_classes}{The number of label classes.}

\item{config}{A run configuration created by \code{\link[=run_config]{run_config()}}, used to configure the runtime
settings.}

\item{input_layer_partitioner}{An optional partitioner for the input layer.
Defaults to \code{min_max_variable_partitioner} with \code{min_slice_size} 64 << 20.}

\item{partitioner}{An optional partitioner for the input layer.}
}
\description{
Base Documentation for Canned Estimators
}
