% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_categorical_with_vocabulary_file}
\alias{column_categorical_with_vocabulary_file}
\title{Construct a Categorical Column with a Vocabulary File}
\usage{
column_categorical_with_vocabulary_file(
  ...,
  vocabulary_file,
  vocabulary_size,
  num_oov_buckets = 0L,
  default_value = NULL,
  dtype = tf$string
)
}
\arguments{
\item{...}{Expression(s) identifying input feature(s). Used as the column
name and the dictionary key for feature parsing configs, feature tensors,
and feature columns.}

\item{vocabulary_file}{The vocabulary file name.}

\item{vocabulary_size}{Number of the elements in the vocabulary. This must be
no greater than length of \code{vocabulary_file}, if less than length, later
values are ignored.}

\item{num_oov_buckets}{Non-negative integer, the number of out-of-vocabulary
buckets. All out-of-vocabulary inputs will be assigned IDs in the range
\verb{[vocabulary_size, vocabulary_size+num_oov_buckets)} based on a hash of the
input value. A positive \code{num_oov_buckets} can not be specified with
\code{default_value}.}

\item{default_value}{The integer ID value to return for out-of-vocabulary
feature values, defaults to \code{-1}. This can not be specified with a positive
\code{num_oov_buckets}.}

\item{dtype}{The type of features. Only string and integer types are
supported.}
}
\value{
A categorical column with a vocabulary file.
}
\description{
Use this when your inputs are in string or integer format, and you have a
vocabulary file that maps each value to an integer ID. By default,
out-of-vocabulary values are ignored. Use either (but not both) of
\code{num_oov_buckets} and \code{default_value} to specify how to include
out-of-vocabulary values. For input dictionary \code{features}, \code{features[key]} is
either tensor or sparse tensor object. If it's tensor object, missing values can be
represented by \code{-1} for int and \code{''} for string. Note that these values are
independent of the \code{default_value} argument.
}
\section{Raises}{

\itemize{
\item ValueError: \code{vocabulary_file} is missing.
\item ValueError: \code{vocabulary_size} is missing or < 1.
\item ValueError: \code{num_oov_buckets} is not a non-negative integer.
\item ValueError: \code{dtype} is neither string nor integer.
}
}

\seealso{
Other feature column constructors: 
\code{\link{column_bucketized}()},
\code{\link{column_categorical_weighted}()},
\code{\link{column_categorical_with_hash_bucket}()},
\code{\link{column_categorical_with_identity}()},
\code{\link{column_categorical_with_vocabulary_list}()},
\code{\link{column_crossed}()},
\code{\link{column_embedding}()},
\code{\link{column_numeric}()},
\code{\link{input_layer}()}
}
\concept{feature column constructors}
