% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{fit.stsm}
\alias{fit.stsm}
\title{Estimation of a STS model}
\usage{
\method{fit}{stsm}(mdl, method = "BFGS", show.iter = FALSE, ...)
}
\arguments{
\item{mdl}{an object of class \code{\link{stsm}}.}

\item{method}{argument of the \code{optim} function.}

\item{show.iter}{logical value to show or hide the estimates at the different
iterations.}

\item{...}{other arguments.}
}
\value{
An object of class "stsm" with the estimated variances.
}
\description{
\code{fit} fits the stsm to the time series y.
}
\examples{
# Local level model
b <- 1
C <- as.matrix(1)
stsm1 <- stsm(Nile, b, C, s2v = c(lvl = 0.5), s2u = c(irr = 1), fit = FALSE)
stsm1 <- fit(stsm1, method = "L-BFGS-B")
}
