% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrectS.R
\name{CorrectS}
\alias{CorrectS}
\title{Function to remove some forms of pluralization.}
\usage{
CorrectS(term_vec)
}
\arguments{
\item{term_vec}{A character vector}
}
\value{
Returns an object of class \code{data.frame} with three columns. The first
column is the argument \code{term_vec}. The second column is the depluralized
version of the words in \code{term_vec}. The third column is a logical, indicating
whether or not the word in \code{term_vec} was changed.
}
\description{
This function takes a character vector as input and removes some
forms of pluralization from the ends of the words.
}
\details{
The entries of the vector should be single words or short n-grams 
without punctuation as the function only looks at the ends of strings. In 
other words, if entries are a paragraph of text. Only the final words will 
get de-pluralized. (Even then, if the final character is a period, as would 
be the case with paragraphs, it's likely that nothing will be de-pluralized.)
}
\note{
WARNING: This does make mistakes for irregular words. You should check 
its results manually. It tends to fail spectacularly for words ending in "es".
}
\examples{
myvec <- c("banana", "bananas", "scientists", "large_armies")

CorrectS(term_vec=myvec)

}

