% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{dtm_get_idf}
\alias{dtm_get_idf}
\title{Inverse Document-Frequency scaling matrix construction}
\usage{
dtm_get_idf(dtm, log_scale = log, smooth_idf = T)
}
\arguments{
\item{dtm}{\code{dgCMatrix} - Document-Term matrix.}

\item{log_scale}{function to use in idf calculation. Usually \link{log} used.
Also worth to try \link{log2}.}

\item{smooth_idf}{\code{logical} smooth idf weights by adding one to document frequencies,
as if an extra document was seen containing every term in the collection exactly once.
Prevents zero divisions.}
}
\value{
\code{ddiMatrix} idf scaling diagonal sparse matrix.
}
\description{
Creates Inverse Document-Frequency (idf) scaling matrix from Document-Term matrix.
 For examples see \link{get_dtm}.
idf = log (# documents in the corpus) / (# documents where the term appears + 1)
For examples see  \link{get_dtm}
}
\seealso{
\link{dtm_get_tf}, \link{get_dtm}
}

