% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-embedding.R
\name{get_centroid}
\alias{get_centroid}
\title{Word embedding semantic centroid extractor}
\usage{
get_centroid(anchors, wv, missing = "stop")
}
\arguments{
\item{anchors}{List of terms to be averaged}

\item{wv}{Matrix of word embedding vectors (a.k.a embedding model)
with rows as words.}

\item{missing}{What action to take if anchor words are not in embeddings.
If action = "stop" (default), the function is stopped
and an error messages states which words are missing.
If action = "remove",  output is the same as terms but
missing words or rows with missing words are removed.
Missing words will be printed as a message.}
}
\value{
returns a one row matrix
}
\description{
\code{get_centroid()} requires a list of terms, one column data.frame or matrix.
The function outputs an averaged vector from a set of anchor terms' word
vectors. This average is roughly equivalent to the intersection of the
contexts in which each word is used. This semantic centroid can be used
for a variety of ends, and specifically as input to \code{\link[=CMDist]{CMDist()}}.
}
\examples{

# load example word embeddings
data(ft_wv_sample)

space <- c("spacecraft", "rocket", "moon")

cen <- get_centroid(anchors = space, wv = ft_wv_sample)
}
\author{
Dustin Stoltz
}
