% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.evmOpt}
\alias{simulate.evmOpt}
\alias{simulate.evmSim}
\alias{simulate.evmBoot}
\title{Simulate from a fitted evm object}
\usage{
\method{simulate}{evmOpt}(object, nsim = 1, seed = NULL,
  param = NULL, ...)

\method{simulate}{evmSim}(object, nsim = 1, seed = NULL, ...)

\method{simulate}{evmBoot}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{A fitted evm object having class 'evmOpt', 'evmSim' or
'evmBoot'.}

\item{nsim}{The number of simulations to perform. Defaults to \code{nsim=1}.
A single simulation involves simulating a new set of responses from the data
that was provided to \code{evm} (after thresholding if thresholding is
performed.)}

\item{seed}{An integer to be passed to \code{set.seed}. Defaults to
\code{seed=NULL}.}

\item{param}{Parameters to use in the random number generator. Defaults to
\code{param=NULL} in which case the parameters from the fitted model are
used.  For \code{simulate.evmSim} and \code{simulate.evmBoot}, this argument
is not available and the simulated parameters or replicates are used.}

\item{...}{Unused.}
}
\value{
If \code{nsim=1}, a vector or random numbers simulated from the
fitted model object.  If \code{nsim > 1}, a matrix with each column being a
set of simulated responses.
}
\description{
Simulate random numbers from a fitted evm object
}
\details{
For \code{simulate.evmSim} and \code{simulate.evmBoot}, the parameters from
the Markov chains or bootstrap replicates are randomly permuted prior to
each set of simulated responses being computed. In this way, reusing the
same set of values is avoided.
}
\examples{

mod <- evm(rain, qu=.95)
hist(simulate(mod, 100))

}
\seealso{
\code{\link{evm}}
}
\author{
Paul Metcalfe, Harry Southworth
}
\keyword{models}
