% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpdProfileLikRetLevels.R
\name{gpd.prof}
\alias{gpd.prof}
\title{Profile likelihood based confidence intervals for GPD}
\usage{
gpd.prof(z, m, xmax, xlow, conf = 0.95, nint = 50, PlotIt = FALSE,
  mult = 2, priorParameters = NULL)
}
\arguments{
\item{z}{a fitted \code{evmOpt} object}

\item{m}{return period : units are number of observations}

\item{xmax}{point estimate of the return level, this is used to bracket the roots of the equation used to calculate the ends of the profile likelihood based confidence interval.  The value need not be exact.}

\item{xlow}{value lower than the lower end of the confidence interval, for bracketing in root finding}

\item{conf}{confidence level, defaults to 0.95}

\item{nint}{used for plotting if required, number of points at which to calculate the profile likelihood for plotting, defaults to 50}

\item{PlotIt}{logical, whether or not to plot the profile likelihood, defaults to \code{FALSE}}

\item{mult}{used to calculate the starting point for the root finding for solving to find the upper end of the confidence interval.  The starting point is \code{mult*xmax} minus the lower end point. If this starting point is beyond the estimated upper endpoint of the fitted distribution then this can cause an error, and the value of \code{mult} should be reduced}

\item{priorParameters}{optional, value of prior/penalty parameters used for penalised likelihood estimation, default to NULL}
}
\value{
Numeric vector of length two, with lower and upper ends of the estiamted confidence intervals respectively.
}
\description{
Calculates profile likelilhood based confidence intervals for a given fitted GPD model -- this is only implemented for two parameter GPD with no covariates in the model.
}
