% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate-promise.R
\name{evaluate_promise}
\alias{capture_messages}
\alias{capture_output}
\alias{capture_warnings}
\alias{evaluate_promise}
\title{Evaluate a promise, capturing all types of output.}
\usage{
evaluate_promise(code, print = FALSE)

capture_messages(code)

capture_warnings(code)

capture_output(code, print = FALSE)
}
\arguments{
\item{code}{Code to evaluate. This should be an unevaluated expression.}

\item{print}{If \code{TRUE} and the result of evaluating \code{code} is
visible this will print the result, ensuring that the output of printing
the object is included in the overall output}
}
\value{
A list containing
 \item{result}{The result of the function}
 \item{output}{A string containing all the output from the function}
 \item{warnings}{A character vector containing the text from each warning}
 \item{messages}{A character vector containing the text from each message}
}
\description{
These functions allow you to capture the side-effects of a function call
including printed output, messages and warnings. They are used to evaluate
code for \code{\link{expect_output}}, \code{\link{expect_message}},
\code{\link{expect_warning}}, and \code{\link{expect_silent}}.
}
\examples{
evaluate_promise({
  print("1")
  message("2")
  warning("3")
  4
})
}

