% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptoticTimeComplexityClass.R
\name{asymptoticTimeComplexityClass}
\alias{asymptoticTimeComplexityClass}
\title{Asymptotic Time Complexity Classifying function}
\usage{
asymptoticTimeComplexityClass(model.df)
}
\arguments{
\item{model.df}{A data frame composed of columns 'Timings' and 'Data sizes', which can be obtained by asymptoticTimings()}
}
\value{
A string specifying the resultant complexity class. (Eg: 'Linear', 'Log-linear', 'Quadratic')
}
\description{
Function to classify the time complexity of the expression passed onto asymptoticTimings (which outputs a data frame to be used here)
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Complexity-classifiers/
}
\examples{
# Avoiding for CRAN since computation time might exceed 5 seconds sometimes:
\donttest{
# Running the quick sort algorithm with sampling against a set of increasing input data sizes:
sizes = 10^seq(1, 3, by = 0.5)
df <- asymptoticTimings(sort(sample(1:100, data.sizes, replace = TRUE), method = "quick"), sizes)
# Classifying the time complexity trend based on the benchmarked data obtained above:
asymptoticTimeComplexityClass(df)
# For quick sort, the log-linear time complexity class is expected.
}
}
